#include <stdlib.h>

#define LENGTH 29   /* length of melody we'll make */

/* transitionweight[i][j] is weight for going from note i to note j */
double transitionweight[8][8] = {
{  0,  2,  1,  1,  1,  1, -1,  1},
{  2,  0,  2,  1,  1,  0,  0, -1},
{  1,  2,  0,  2,  1,  0, -1,  0},
{  1,  1,  2,  0,  2,  1, -2,  0},
{  1,  1,  1,  2,  0,  2,  1,  1},
{  0, -1, -1,  1,  2,  0,  2,  1},
{ -1,  0, -1, -1,  1,  2,  0,  2},
{  1, -1,  0,  0,  1,  1,  1,  0},
};

double transitions(int mel[])
{
    double foo = 0;
    int i;
    for (i = 0; i < LENGTH-1; i++)
    {
        /* post("add %d %d %lf", mel[i], mel[i+1],
            transitionweight[mel[i]][mel[i+1]]); */
        foo += transitionweight[mel[i]][mel[i+1]];
    }
    return (foo);
}

double repetitions(int mel[])
{
    double foo = 0;
    int i;
    for (i = 0; i < LENGTH-4; i++)
        if (mel[i] == mel[i+2] && mel[i+1] == mel[i+3])
            foo -= 1;
    return (foo);
}

double contour(int mel[])
{
    double foo = 0;
    int i;
    for (i = 0; i < 10; i++)
    {
        if (mel[i] < 3)
            foo += 1;
    }
    for (i = 15; i < 25; i++)
    {
        if (mel[i] > 4)
            foo += 1;
    }
    for (i = LENGTH-2; i < LENGTH; i++)
    {
        if (mel[i] < 3)     
            foo += 3;
    }
    return (foo);
}

int wanttonality[] = 
{1, 3, 1, 2, 1, 0, 1, 0,
 3, 0, 3, 0, 1, 2, 1, 0,
 1, 2, 1, 3, 1, 0, 1, 3,
 0, 1, 2, 3, 1};

double pitchtonalities[3][8] = {
{2, 0, 2, 0, 2, 0, 0, 2},
{2, 0, 0, 2, 0, 2, 0, 2},
{0, 2, 0, 2, 2, 0, 2, 0},
};
   
double tonality(int mel[])
{
    double foo = 0;
    int i;
    for (i = 0; i < LENGTH; i++)
        if (wanttonality[i] > 0)
            foo += pitchtonalities[wanttonality[i]-1][mel[i]];
    return (foo);
}
   
double similarity(int mel[])
{
    double foo = 0;
    int i;
    for (i = 0; i < 12; i++)
        if (mel[i+1] - mel[i] == mel[i+17] - mel[i+16])
            foo += 1;
    /* for (i = 0; i < 12; i++)
        if (mel[i+1] - mel[i] == mel[20-i] - mel[21-i])
            foo += 1; */
    return (foo);
}

double getscore(int mel[], double f3, double f4, double f5, double f6, 
    double f7)
{
    return (0
         + f3*transitions(mel)
         + f4*repetitions(mel)
         + f5*contour(mel)
         + f6*tonality(mel)
         + f7*similarity(mel)
    );
}

void perturb(int mel[], int outmel[], int nchange)
{
    int index = (int)((double)(random()) *
        (double)(LENGTH-nchange) / RAND_MAX), i;
    if (index >= LENGTH+1-nchange)
        index = LENGTH-nchange;
    for (i = 0; i < LENGTH; i++)
        outmel[i] = mel[i];
    for (i = index; i < index+nchange; i++)
    {
        outmel[i] = (int)((double)(random()) * 8. / RAND_MAX);
        if (outmel[i] > 7)
            outmel[i] = 7;
    }
}

static int currentmel[LENGTH];

void melodysearch(double f1, double f2,
    double f3, double f4, double f5, double f6, double f7)
{
    if (f1 == 0)        /* 0: start from scratch */
    {
        int i;
        for (i = 0; i < LENGTH; i++)
            currentmel[i] = random() * 8. / RAND_MAX;
        if (currentmel[i] > 7)
            currentmel[i] = 7;
    }
    else if (f1 == 1)        /* 1: output a note */
    {
        int whichnote = f2;
        if (whichnote < 0)
            whichnote = 0;
        if (whichnote >= LENGTH)
            whichnote = LENGTH-1;
        cfc_sendoutlet(1, (double)currentmel[whichnote]);
    }
    else if (f1 == 2)        /* 2: run optimizer, f2 times, with 
                                weights f3, f4, f5, and f6 */
    {
        int i, nchange = 0;
        double currentscore = getscore(currentmel, f3, f4, f5, f6, f7);
        for (i = 0; i < f2; i++)
        {
            int newmel[LENGTH];
            double newscore;
            perturb(currentmel, newmel, 2);
            newscore = getscore(newmel, f3, f4, f5, f6, f7);
            if (newscore >= currentscore)
            {
                int j;
                for (j = 0; j < LENGTH; j++)
                    currentmel[j] = newmel[j];
                currentscore = newscore;
                nchange++;
            }
        }
        post("nchange %d, score %lf", nchange, currentscore);
    }
    else if (f1 == 3)        /* 3: run optimizer, f2 times, with 
                                weights f3, f4, f5, and f6, changing
                                3 elements each time */
    {
        int i, nchange = 0;
        double currentscore = getscore(currentmel, f3, f4, f5, f6, f7);
        for (i = 0; i < f2; i++)
        {
            int newmel[LENGTH];
            double newscore;
            perturb(currentmel, newmel, 3);
            newscore = getscore(newmel, f3, f4, f5, f6, f7);
            if (newscore > currentscore)
            {
                int j;
                for (j = 0; j < LENGTH; j++)
                    currentmel[j] = newmel[j];
                currentscore = newscore;
                nchange++;
            }
        }
        post("nchange %d, score %lf", nchange, currentscore);
    }
}

