
/* get the interval vector of a chord.  The caller supplies the
array "chord[]" with "chordsize" elements.  The output is put in
the array "outarray[]" which should have seven elements. */

void getintervalvec(int chordsize, double chord[], double outarray[])
{
    int i, j;
    for (i = 0; i < 7; i++)
        outarray[i] = 0;
    for (i = 1; i < chordsize; i++)
        for (j = 0; j < i; j++)
    {
        int interval = chord[j] - chord[i];
        if (interval < 0)
            interval = -interval;
        interval = interval % 12;
        if (interval > 6)
            interval = 12 - interval;
        outarray[interval] += 1;
    }
}

/* get the pitch class histogram of a chord.  The caller supplies the
chhor and its size; the output is put in "outarray[]" which should
have 12 elements. */

void getpitchhistogram(int chordsize, double chord[], double outarray[])
{
    int i;
    for (i = 0; i < 12; i++)
        outarray[i] = 0;
    for (i = 0; i < chordsize; i++)
        outarray[(int)(chord[i])%12] += 1;
}

/* get the "tonality" vector of a chord: the twelve elements measure how
strongly the chord fits the tonality.   */

double tonalweight[12] = {3, -1, 1, 1, 2, -1, -1, 3, -2, 0, 2, 0};

void gettonalityvec(int chordsize, double chord[], double outarray[])
{
    int i, j;
    double histo[12];
    getpitchhistogram(chordsize, chord, histo);
    for (i = 0; i < 12; i++) 
    {
        outarray[i] = 0;
        for (j = 0; j < 12; j++)
        {
            int degree = (j + 12 - i)%12;
            if (histo[j] > 0)
                outarray[i] += tonalweight[degree];
        }
    }
}

void maxtonality(double f1, double f2, double f3, double f4, double f5,
    double f6)
{
    double chord[6], tonality[12], mosttonal;
    int i, bestroot, chordsize = 6;
    chord[0] = f1;
    chord[1] = f2;
    chord[2] = f3;
    chord[3] = f4;
    chord[4] = f5;
    chord[5] = f6;
    while(chordsize > 0 && chord[chordsize-1] == 0)
        chordsize--;
    gettonalityvec(chordsize, chord, tonality);
    /* for (i = 0; i < 12; i++)
        post("tonality %lf", tonality[i]); */
    for (mosttonal = -100000, i = bestroot = 0; i < 12; i++)
        if (tonality[i] > mosttonal)
    {
        mosttonal = tonality[i];
        bestroot = i;
    }
    cfc_sendoutlet(2, mosttonal);
    cfc_sendoutlet(1, (double)bestroot);
}


void findtonalneighbor(double f1, double f2, double f3, double f4, double f5,
    double f6)
{
    double chord[6], nc[6], outchord[6], tonality[12], mosttonal = -100000;
    int i, j, chordsize = 6;
    chord[0] = f1;
    chord[1] = f2;
    chord[2] = f3;
    chord[3] = f4;
    chord[4] = f5;
    chord[5] = f6;
    while(chordsize > 0 && chord[chordsize-1] == 0)
        chordsize--;
    post("foo");
    for (i = 0; i < 6; i++)
        outchord[i] = 0;
    for (nc[0] = chord[0] - 1; nc[0] < chord[0] + 2; nc[0] += 1)
     for (nc[1] = chord[1] - 1; nc[1] < chord[1] + 2; nc[1] += 1)
      for (nc[2] = chord[2] - 1; nc[2] < chord[2] + 2; nc[2] += 1)
       for (nc[3] = chord[3] - 1; nc[3] < chord[3] + 2; nc[3] += 1)
        for (nc[4] = chord[4] - 1; nc[4] < chord[4] + 2; nc[4] += 1)
         for (nc[5] = chord[5] - 1; nc[5] < chord[5] + 2; nc[5] += 1)
    {
        gettonalityvec(chordsize, nc, tonality);
        for (i = 0; i < 12; i++)
        {
            for (j = 0; j < chordsize; j++)
            {
                float diff = chord[j] - nc[j];
                if (diff < 0)
                    diff = -diff;
                tonality[i] -= diff;
            }
            if (tonality[i] > mosttonal)
            {
                for (j = 0; j < chordsize; j++)
                    outchord[j] = nc[j]; 
                mosttonal = tonality[i];
            }
        }
    }
    post("chordsize %d", chordsize);
    for (i = 6; i > 0; i--)
        cfc_sendoutlet(i, outchord[i-1]);
}

